<?php
include('connection.php');

// Initialize search flag
$search_performed = false;

// Handle search functionality
$search_query = "SELECT * FROM pastpapers WHERE 1=1";
$search_params = [];

if (isset($_POST['search'])) {
    $form = $_POST['form'];
    $subject = $_POST['subject'];
    $exam_type = $_POST['exam_type'];
    $year = $_POST['year'];

    if ($form != "") {
        $search_query .= " AND form = ?";
        $search_params[] = $form;
    }
    if ($subject != "") {
        $search_query .= " AND subject = ?";
        $search_params[] = $subject;
    }
    if ($exam_type != "") {
        $search_query .= " AND exam_type = ?";
        $search_params[] = $exam_type;
    }
    if ($year != "") {
        $search_query .= " AND year = ?";
        $search_params[] = $year;
    }

    $stmt = $con->prepare($search_query);

    // Bind the parameters dynamically based on what the user searches for
    if (!empty($search_params)) {
        $types = str_repeat("s", count($search_params));
        $stmt->bind_param($types, ...$search_params);
    }

    $stmt->execute();
    $result = $stmt->get_result();
    $search_performed = true; // Mark that search has been done
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teacher|Search Past Papers</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .header, .footer {
            background-color: #343a40;
            color: white;
            padding: 20px 0;
        }
        .footer {
            text-align: center;
            margin-top: 40px;
        }
        .header h1 {
            margin: 0;
        }
        .table-responsive {
            margin-top: 20px;
        }
        .search-form {
            margin-top: 20px;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>

<!-- Header -->
<div class="header text-center">
    <h1>Search and Download Examination Past Papers</h1>
</div>

<div class="container my-5">
    <!-- Search Form -->
    <div class="search-form">
        <form action="" method="POST">
            <div class="form-row">
                <div class="form-group col-md-3">
                    <label for="form">Select Form:</label>
                    <select class="form-control" id="form" name="form">
                        <option value="">All Forms</option>
                        <option value="Form 1">Form 1</option>
                        <option value="Form 2">Form 2</option>
                        <option value="Form 3">Form 3</option>
                        <option value="Form 4">Form 4</option>
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="subject">Select Subject:</label>
                    <select class="form-control" id="subject" name="subject">
                        <option value="">All Subjects</option>
                        <option value="physics">Physics</option>
                        <option value="chemistry">Chemistry</option>
                        <option value="biology">Biology</option>
                        <option value="basic mathematics">Basic Mathematics</option>
                        <option value="english language">English Language</option>
                        <option value="history">History</option>
                        <option value="geography">Geography</option>
                        <option value="kiswahili">Kiswahili</option>
                        <option value="civics">Civics</option>
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="exam_type">Select Exam Type:</label>
                    <select class="form-control" id="exam_type" name="exam_type">
                        <option value="">All Exam Types</option>
                        <option value="Necta">Necta</option>
                        <option value="Mock">Mock</option>
                        <option value="Midterm_first">Midterm First</option>
                        <option value="Terminal">Terminal</option>
                        <option value="Midterm_second">Midterm Second</option>
                        <option value="Annual">Annual</option>
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="year">Select Year:</label>
                    <select class="form-control" id="year" name="year">
                        <option value="">All Years</option>
                        <?php
                        $current_year = date("Y");
                        for ($year = 2010; $year <= $current_year; $year++) {
                            echo "<option value='$year'>$year</option>";
                        }
                        ?>
                    </select>
                </div>
            </div>
            <button type="submit" name="search" class="btn btn-primary btn-block">Search</button>
        </form>
    </div>

    <!-- Display Results only after search -->
    <?php if ($search_performed): ?>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="thead-dark">
                <tr>
                    <th>Form</th>
                    <th>Subject</th>
                    <th>Exam Type</th>
                    <th>Year</th>
                    <th>Poster</th>
                    <th>Paper</th>
                    <th>Marking Scheme</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $row['form'] . "</td>";
                        echo "<td>" . ucfirst($row['subject']) . "</td>";
                        echo "<td>" . ucfirst($row['exam_type']) . "</td>";
                        echo "<td>" . $row['year'] . "</td>";
                        echo "<td>" . $row['poster_name'] . "</td>";
                        echo "<td><a href='" . $row['paper_file'] . "' class='btn btn-primary' download>Download Paper</a></td>";
                        echo "<td><a href='" . $row['marking_scheme_file'] . "' class='btn btn-secondary' download>Download Marking Scheme</a></td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='7' class='text-center'>No papers found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
</div>

<!-- Footer -->
<div class="footer">
    <p>&copy; <?php echo date('Y'); ?> Examination Portal | All Rights Reserved</p>
</div>

<!-- Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
